;*****************************************************************************
;*                                                                           *
;*   	Routine de multiplication A*B. A et B sur 8 bits avec un signe.      *
;*       A sign et stock en 'mula'.					     *
;*       B non sign et stock en 'mulb'.				     *
;*       Rsultat sur 16 bits dans 'lstb' et 'mstb'.                         *
;*	 'mula' inchang. 'mulb' mis  0.				     *
;*       Registres affects : a,v,x=mulb.                                    *
;*   +  Routine de division A/B.  A(16bits) et B(8bits) non signs.          *
;*       bits de poids fort de A stocks en 'divA',			     *
;*       bits de poids faible de A stocks en 'quotient'.  		     *
;*       divB doit tre suprieur  divA pour avoir un rsultat sur 8 bits   *
;*       Les bits les plus significatifs de divA et de divB doivent valoir 0 *
;*       Rsultat dans  'quotient'                                           *
;*       Registres affects : a,v                                            *
;*   +  Routine de convertion binaire->decimal (ascii)                       *
;*	 "decimal": Entre A (non sign), rsultat en 'cent','dix' et 'unit' *
;*       "decsgn" : Idem avec A sign, signe stock en 'signe'		     *
;*       Registres affects : a,v,division),x,y                              *
;*   +  Deux routines de convertion binaire->hexadcimal (ascii)             *
;*       Entre A, rsultat en 'mstnib' et 'lstnib' pour "bytehexa"          *
;*       Entre A, sortie A pour "nibhexa"                                   *
;*       Registres affects : a,v                                            *
;*									     *
;*****************************************************************************

;|===========================================================================|
;| Assembly method without linker : ast6 -l -m -x -e -o multip.asm           |
;|===========================================================================|

;|===========================================================================|
;|                          Assembly directives                              |
;|===========================================================================|

	 .title	"MULTIP"          ; This directive defines a new title to be
				  ; in the page header of the output listing.
	 .vers "st6210"
         .romsize 2

	 .pp_on                   ; This directive is to be included when the
				  ; program space is segmented in 2 K page.
				  ; This directive allows the use of .SECTION
				  ; directive.

	 .global multip,divis,decimal,decsgn,bytehexa,nibhexa

;*****************************************************************************
;*                               Data space                                  *
;*****************************************************************************

;|===========================================================================|
;|                             Data registers                                |
;|===========================================================================|

	 .notransmit
	 .input "6215_reg.asm"
	 .input "multip.def"
	 .transmit

	 .section 1

multip	 clr lstb       ; Mise a zero du rsultat
	 clr mstb
	 ld a,mulb
	 ld x,a         ; sauvegarde mulb pour traitement du signe.

	 ldi v,8	; 540 cycles d'horloge, au pire
			; 0.9ms  8Mhz
mult	 ld a,lstb      ; Dcalage  gauche du rsultat
	 sla a	   	; d'un bit
	 ld lstb,a
	 ld a,mstb
	 rlc a
	 ld mstb,a

	 ld a,mulb        ; Dcalage du multiplicateur (non sign)
	 sla a
	 ld mulb,a

	 jrnc chcnt    ; Retenue = 1 ?

	 ld a,lstb     ; Oui, ajout multiplicande (sign) au rsultat
	 add a,mula
	 ld lstb,a
	 jrnc chcnt

	 inc mstb

chcnt	 dec v
	 jrz correc
	 jp mult

correc	 jrr 7,mula,retour
	 ld a,mstb
	 sub a,x
	 ld mstb,a

retour	 ret

;****************

divis	 ldi v,8                ; 360 cycles d'horloge

div	 ld a,quotient
	 sla a
	 ld quotient,a
	 ld a,diva
	 rlc a
	 ld diva,a

	 sub a,divb
	 jrc cpt

	 ld diva,a
	 inc quotient

cpt      dec v
	 jrz fin
	 jp div

fin	 ret

;**************

decimal	 cpi a,200
	 jrc not200
	 subi a,200
	 ldi cent,2+'0'
	 jp char10

not200	 cpi a,100
	 jrc not100
	 subi a,100
	 ldi cent,1+'0'
	 jp char10

not100	 ldi cent,0+'0'

char10   ld x,a

	 ldi diva,0
	 ld quotient,a
	 ldi divb,10
	 call divis

	 ld a,quotient
	 addi a,'0'
	 ld dix,a
	 ld a,quotient
	 add a,a
	 add a,a
	 add a,quotient
	 ld y,a

	 ld a,x
	 sub a,y
	 addi a,'0'
	 ld unit,a

	 ret

;***********

decsgn   ldi signe,'+'
	 jrr 7,a,positif
	 com a
	 inc a
	 ldi signe,'-'
positif  jp decimal

;***********

bytehexa ld v,a
	 andi a,0Fh
	 call nibhexa
	 ld lstcar,a
	 ld a,v
	 rlc a
	 rlc a
	 rlc a
	 rlc a
	 rlc a
	 andi a,0Fh
	 call nibhexa
	 ld mstcar,a
	 ret

nibhexa	 addi a,'0'
	 cpi a,'9'+1
	 jrc fini
	 addi a,'A'-('9'+1)
fini	 ret


