;*****************************************************************************
;*                                                                           *
;*             Alarme sur dtection de phnomne priodique                  *
;*                                                                           *
;*****************************************************************************

;|===========================================================================|
;| Assembly method with linker : ast6 -l -m -x -o -e ronfleur.asm            |
;|   Linker   lst6 -s -j -m -i -p1:880-f9f -o ronfleur ronfleur multip       |
;|===========================================================================|

; Historique:
; Cration le 14/01/93 pour J-F-Clment contre le ronfleur : Christian
; 16/01/93 Test Hardware Digital fini. Paramtres configurables par portB.
;          Deux types de sirnes.
; 20/01/93 Maintenant, la mesure sur B0 du niveau de bruit est ralise par
;          une CAN. En mettant les broches B[4..3]=00, le micro passe en
;	   mode reglage. Il met la sirne en marche pour pouvoir en rgler
;          le volume.
; 22/01/93 ~ 24/01/93 Ralisation pratique du circuit
; 24/01/93 Correction Bug vfreq  2000Hz.
;	   Au dmarrage, on fait cligoter la led pour confimer le bon
; 	   fonctionnement du microcontrleur et pour attendre la stabilisation
;	   de la partie amplification.
;	   En cas d'galit de deux tempo successives, ratio retourne 255.
; 25/01/93 Limitation de la dure de la sonnerie  4 secondes environ.
;          Si la dure d'un silence ou d'un bruit est suprieure  9.4s,
;          le compteur de ronflement est remis  0.
;          Cela vite de prendre des bruits (silences) courts et loigns
;          dans le temps pour des ronflements (expirations).
;          Modification de la signification des broches de configuration
; Nuit du 25/01/93 Premier test grandeur nature.
;          La dtection fonctionne parfaitement, mais la sirne rveille tout
;          le monde sauf christian (le ronfleur)
; 26/01/93 Ajout de nouvelles sirnes : Une sirne de 2s intermitente, une
;          sirne donnant trois coups de laserwarp (1.5s),un LaserWarp rapide.
;          A chaque nouvelle dtection, on change de sirne.
; 27/01/93 L'alarme LaserWarp se rvle tre inefficace.
; 28/01/93 Essai avec une seule alarme: 4 bips volume  fond.
; 31/01/93 Utilisation de Hour,Min,Second pour avoir une horloge interne
;	   Elle permet d'inhiber le dclenchement de l'alarme pendant
;	   certaines priodes de la nuit. Elle est incrmente toutes les
;          36.86ms. Hour est incrment de 1 toutes les 0.671 heures.
;	   Algorithme: Si une dtection survient alors que Heure>14 (Hour>21),
;	   cela signifie qu'une nouvelle nuit vient de dbuter. On remet
;	   l'horloge  0 et on dclenche l'alarme. Autrement, ne dclencher
;	   l'alarme qu'avant 2 heures (Hour<3) et aprs 6 heures (Hour>=9).
;
; Commentaires: La dtection du ronflement se base sur la reconnaissance
;               du cycle silence-ronflement.
;               La prcision de la priodicit du cycle de mme que le
;               nombre de cycles successifs reconnus, ncessaires au
;               dclenchement de l'alarme sont configurables par le port B.
;               x est une variable globale. Contient l'adresse du prochain
;               octet dans la liste circulaire du filtre passe-bas.

;|===========================================================================|
;|                          Assembly directives                              |
;|===========================================================================|

	 .title	"RONFLEUR"        ; This directive defines a new title to be
				  ; in the page header of the output listing.
	 .vers "st6215"
         .romsize 2

	 .w_on

	 .pp_on                   ; This directive is to be included when the
				  ; program space is segmented in 2 K page.
				  ; This directive allows the use of .SECTION
				  ; directive.

	 .extern divis

;*****************************************************************************
;*                               Data space                                  *
;*****************************************************************************

;|===========================================================================|
;|                             Data registers                                |
;|===========================================================================|

	 .input "6215_reg.asm"
         .input "bits.def"

;|===========================================================================|
;|                                data ram                                   |
;|  			 Elle s'tend de 84h  BFh                           |
;|===========================================================================|

         .input "multip.def"

values   .def 084h    ; zone de 26 octets pour filtrage passe-bas.

lastT0   .def 0B0h    ; Dure du dernier silence
lastT1   .def 0B1h    ; Dure du dernier bruit (ronflement ou autre)
newT     .def 0B2h    ; Dure du silence ou du bruit en cours.
		      ; Sature  255 soit 255*36.86ms=9.4s
alarmnb  .def 0B3h    ; Numro de l'alarme  dclencher
etat     .def 0B4h    ; Etat actuel en sortie du filtre passe bas
ronfcnt  .def 0B5h    ; Nombre de corrlations dtectes
alarmcnt .def 0B6h    ; Compteur pour la dure de l'alarme
error    .def 0B7h    ; Taux d'erreur admis
wfreq    .def 0B8h    ; Valeurs dterminant la frquence produite
vfreq    .def 0B9h    ;  par le haut parleur
tabsize  .def 0BAh    ; Taille du tableau du filtre passe bas
seuil    .def 0BBh    ; Moiti de tabsize
idcnt    .def 0BCh    ; Nombre de corrlations de dures avant alarme


;*****************************************************************************
;*                             PROGRAM SPACE                                 *
;*****************************************************************************

;|===========================================================================|
;|                             main program                                  |
;|===========================================================================|

	 .section 1               ; This directive provides a logical
				  ; partionning of the program space.

reset    ldi wdr,0feh             ; Load the watchdog.

	 ldi ddra,11111111b       ; Port A:  A[0..3] sortie Collecteur ouvert
	 ldi  ora,00000000b       ;
	 ldi  dra,11111111b	  ;

; A[0] Connect  la base du darlington du Haut Parleur.
; A[1] Valeur en sortie du filtre passe bas numrique.

	 ldi ddrb,00000000b       ; Port B:  Tout en entre pull-up
	 ldi  orb,00000001b       ; Sauf pour l'entre analogique en
	 ldi  drb,00000001b	  ; provenance de l'ampli.

; B[0] entre en provenance de l'ampli, redresse dans [0V-5V].
; Broches de configuration:
; B[2].B[1] dtermine le taux d'erreur admis
; B[2].B[1]: 00 -> 25% , 01 -> 35%, 10 -> 45%, 11 -> 55%
; B[4].B[3] dtermine le ton de la sonnerie
; B[4].B[3]: 00 -> LaserWarp, 01 -> Intermitente, 10 -> BiWarp, 11 -> 2000Hz
; B[5] dtermine la vitesse de dclenchement de l'alarme
; B[5]: 0 -> aprs 3 valeurs identiques, 1 -> aprs 6.
; B[6] dtermine la constante de temps du filtre passe bas
; B[6]: 0 -> 0.22s (6*36.86ms), 1 -> 0.48s (13*36.86ms)
; B[7] dtermine le type de sirne lors de l'alarme
; B[7]: 0 -> Rglage H.P., 1 -> Fonctionnement normal.


	 ldi adcr,00010000b       ; Mise sous tension du CAN. Ints interdites.


	 ldi ior,00010000b        ; Enable the interrupts.
	 reti

	 ldi wdr,0feh       ; 196608 Cycles.  39.32ms @ 5Mhz
	 ldi tcr,0ffh       ; 195840 Cycles.  39.17ms @ 5Mhz
	 ldi tcr,0f0h       ; 184320 Cycles.  36.86ms @ 5Mhz
	 ldi tscr,01101110b

	 call initram
	 ldi x,values

	 jrs 7,drb,letsgo    ; Passage en mode rglage H.P. si B7=0
	 jp hptest

letsgo   ldi y,10            ; Dure du clignotement:5 secondes
cligloop ldi v,159           ; Transition:4 fois/seconde : T=0.25s
	 ldi w,100	     ; v=159,w=100.
	 call waitIT
	 res 1,dra           ; Allume led
	 ldi v,159
	 ldi w,100
	 call waitIT
	 set 1,dra	     ; Eteind led
	 dec y
	 jrz mainloop
	 jp cligloop

mainloop wait
	 call readit
	 call makesum
	 cp a,seuil
	 jrnc IS1
	 ldi a,0
	 res 1,dra      ; Indique valeur en sortie du filtre passe bas
	 jp IS0
IS1	 ldi a,1
	 set 1,dra      ; Idem
IS0      cp a,etat
	 jrz same_st
	 jp newstate
same_st  inc newT
	 jrnz nover
         ldi ronfcnt,0  ; remise  0 du compteur si dpassement.
nover    jp mainloop


newstate ld etat,a
	 call ratio
	 ld v,a
	 ld a,newT         ; On ractualise tout de suite les compteurs
	 jrr 0,etat,itwas1
	 ld lastT0,a
	 jp itwas0

itwas1   ld lastT1,a

itwas0   ldi newT,0
	 ld a,v
	 cp a,error      ; Verifie si erreur < taux d'erreur admis
	 jrnc sameT
	 ldi ronfcnt,0   ; Si erreur > taux admis, recommencer  0.
	 jp mainloop

sameT    inc ronfcnt
	 ld a,ronfcnt
	 cp a,idcnt
	 jrz goalarm
	 jp mainloop

goalarm  call alarme
	 ldi ronfcnt,0
	 jp mainloop



;*****************************************************************************
;* 			Sous programmes					     *
;*****************************************************************************

initram  ldi lastT0,1
         ldi lastT1,1
	 ldi newT,0
         ldi etat,0
	 ldi ronfcnt,0
	 ldi hour,50     ; Ainsi,  la premire alarme, horloge<-0
	 ldi min,0
	 ldi second,0
         ldi x,values
         ldi v,26
	 ldi a,0
initloop ld (x),a
	 inc x
         dec v
	 jrnz initloop

; Mmorisation du taux d'erreur admis.

	 ld a,drb
	 andi a,00000110b
	 cpi a,000b
	 jrnz not25
	 ldi error,192
not25	 cpi a,010b
	 jrnz not35
	 ldi error,166
not35    cpi a,100b
	 jrnz not45
	 ldi error,141
not45    cpi a,110b
	 jrnz not55
	 ldi error,115

; Memorisation du numro d'alarme  partir de la config des jumpers

not55    ld a,drb
	 andi a,00011000b
         rlc a
         rlc a
         rlc a
         rlc a
         rlc a
         rlc a
         andi a,11b
         ld alarmnb,a

; Mmorisation du nombre de corrlations dtectes
; avant dclenchement de l'alarme.

not2000  ldi idcnt,3
	 jrr 5,drb,issmall
	 ldi idcnt,6

; Memorisation de la constante de temps du filtre passe bas.

issmall  ldi seuil,6
	 ldi tabsize,12
	 jrr 6,drb,quickT
	 ldi seuil,13
	 ldi tabsize,26

quickT   ret


;*****************************************************************
;-----------------------------------------------------------------
;*****************************************************************

readit   ldi adcr,10110000b
	 wait	           ; Attente du rsultat de la convertion.
	 ld a,adr
	 cpi a,128         ; Seuil de bruit fix  50%
	 ldi a,0
	 jrc okzero
	 ldi a,1
okzero   ld (x),a
	 inc x
	 ldi a,values
	 add a,tabsize
	 cp a,x
	 jrnz finread
	 ldi x,values
finread  ret

;*********************************

makesum  ldi y,values
	 ld a,tabsize
	 ld v,a
	 ldi a,0
sumloop  add a,(y)
	 inc y
	 dec v
	 jrnz sumloop
	 ret


;**********************************

ratio    ld a,newT
	 ld v,a
	 ld a,lastT1
	 jrr 0,etat,WAS1
	 ld a,lastT0

WAS1     jrs 7,v,shift_r
	 jrs 7,a,shift_r
	 jp compare
shift_r  rlc a
	 rlc a
	 rlc a
	 rlc a
	 rlc a
	 rlc a
	 rlc a
	 rlc a
	 andi a,7Fh
	 ld w,a
         ld a,v
	 rlc a
	 rlc a
         rlc a
         rlc a
	 rlc a
         rlc a
	 rlc a
         rlc a
         andi a,7Fh
	 ld v,a
         ld a,w

compare  cp a,v
	 jrc noexch
	 jrnz exchange
	 ldi a,255
	 ret			; Cas o il y a galit:retourne 255
exchange ld w,a
         ld a,v
         ld y,a
         ld a,w
	 ld v,a
         ld a,y
noexch   ldi quotient,0
         ld diva,a
         ld a,v
	 ld divb,a
	 call divis
	 ld a,quotient
	 ret

;*****************************

waitIT   ld a,v              ; Dure=13.0*(w*(4.0+v*6+6)+2.0)/5e6
loopwait dec a               ; w=5,v=22 -> 250hz @ 5Mhz  i.e. 2ms
	 jrnz loopwait       ; w=5,v=10 -> 500Hz   1.00ms
	 dec w 		     ; w=1,v=21 -> 1000Hz  0.50ms
	 jrnz waitIT         ; w=1,v=05 -> 2000Hz  0.25ms
	 ret		     ; Correction de 0.14ms prise en compte.

;******************************

alarme   ld a,hour
	 cpi a,21
	 jrc nohclr
	 clr hour
	 clr min
	 clr second
nohclr   cpi a,3
	 jrc do_alarm
	 cpi a,9
	 jrnc do_alarm
	 ret
do_alarm jp alarm6

; Code non utilis dans la dernire version

        ld a,alarmnb
        inc a
        cpi a,5               ; Il y a 5 alarmes diffrentes
        jrnz oknb
        ldi a,0
oknb    ld alarmnb,a
        ld a,lastT1
	add a,lastT0
	jrnc nocarry
	ldi a,255
nocarry cpi a,128             ; Limitation de la dure  un peu plus de 4s
        jrc nolimit           ; En fait, ne concerne que alarm1
        ldi a,128
nolimit ld alarmcnt,a
        ld a,alarmnb
        cpi a,3
        jrnz notmono
        ldi wfreq,1
        ldi vfreq,5
        jp alarm1
notmono cpi a,0
        jrnz notwarp
	jp alarm2
notwarp cpi a,1
        jrnz notint
        jp alarm3
notint  cpi a,2
        jrnz notW2
        jp alarm4
notW2   jp alarm5

;***** Alarme Monocorde *****

alarm1  ldi wdr,0feh            ; Dure d'un tour=14*13*4=728 cycles
	ld a,wfreq		; cela donne 0.14ms
	ld w,a
	ld a,vfreq
	ld v,a
	call waitIT
	jrs 0,dra,resetIt
	set 0,dra
	jp suite
resetIt res 0,dra
suite	ld a,alarmcnt
	cpi a,0
	jrz final
	jp alarm1
final   set 0,dra               ; Extinction alarme.
	ret


;****** Alarme a frquence dcroissante LaserWarp ******************
;******      f>120 Hz
;******  Dure du cycle=0.5s
;******  N'est plus utilise

alarm2  ldi wdr,0feh
	ldi w,1
	ld a,vfreq
	ld v,a
	call waitIT
	inc vfreq
	jrs 0,dra,tozero
	set 0,dra
	jp cmpzero
tozero  res 0,dra
cmpzero ld a,alarmcnt
	jrz fini
	jp alarm2
fini    set 0,dra
	ret

;*******   Alarme Intermitente: Dure 2s, 12 interruptions ********
;*******   Frquence 2000 Hz

alarm3 ldi y,12
al3l   wait
       ldi alarmcnt,2
loop31 ldi w,1
       ldi v,5
       call waitIT
       jrs 0,dra,off
       set 0,dra
       jp cmp0
off    res 0,dra
cmp0   ld a,alarmcnt
       jrz silent
       jp loop31
silent set 0,dra
       ldi v,136
       ldi w,50
       call waitIT
       dec y
       jrz fini3
       jp al3l
fini3  ret

;*******   Alarme : 3 coups de LaserWarp  ******
;*******    N'est plus utilise           ******

alarm4 ldi alarmcnt,42
       ldi vfreq,1
       jp alarm2

;*******   Alarme LaserWarp Rapide (0.036s)x54   *********

alarm5 ldi y,54
al5l   ldi alarmcnt,1
       ldi vfreq,1
       call alarm2
       dec y
       jrnz al5l
       ret

;******* Alarme Intermittente comme alarm3. Dure 1s ***********
;******* Attend qu'il y ait le silence avant de se dclencher *****

alarm6 wait
       call readit
       call makesum
       cp a,seuil
       jrnc alarm6
       ldi y,6
       jp al3l

;*******   Mode rglage du volume du Haut Parleur     *********************


hptest  ldi lastT0,32
        ldi lastT1,32
        call alarme
        jp hptest

;|===========================================================================|
;|                         interrupt routines                                |
;|===========================================================================|

;|---------------------------------------------------------------------------|
;|                          portc interrupt                                  |
;|---------------------------------------------------------------------------|

it_portc reti

;|---------------------------------------------------------------------------|
;|                          timer interrupt                                  |
;|---------------------------------------------------------------------------|

it_timer  res tmz,tscr
	  ldi tcr,0f0h
	  ldi wdr,0feh             ; Reload the watchdog.
	  dec alarmcnt
	  inc second
	  jrnz it_end
	  inc min
	  jrnz it_end
	  inc hour
it_end	  reti

;|---------------------------------------------------------------------------|
;|                          A/D Converter interrupt                                  |
;|---------------------------------------------------------------------------|

it_adc   ldi adcr,01010000b
	 reti


;*****************************************************************************
;*                    interrupt and restart vectors                          *
;*****************************************************************************

	 .section 32

adc      jp it_adc
timer    jp it_timer
int2     nop
	 reti
int1     nop
	 reti
	 nop
	 nop
	 nop
	 nop
nmi      nop
	 reti
res      jp reset
