#include <stdio.h>
#include <stdlib.h>
#include <process.h>

/*
    Code Converts GIF files in RAW files 
    Filters horizontally 2->1
    and interlaces them in a single TIFF file

    Reads in Current directory
*/

typedef unsigned char u8;

typedef struct basic_image {
	int nc;
	int nl;
	u8 *p;
};

int newim(struct basic_image *im)
{
  if ((im->p = (u8 *) malloc(3*im->nc*im->nl))==NULL)
		return -1;

	return 0;
}

void freeim(struct basic_image *im)
{
  free(im->p);
}

int readim(char *s, struct basic_image *im)
{
	FILE *f;

  if ((f=fopen(s,"rb"))==NULL)
   return -1;

	fread(im->p,3*im->nc*im->nl,1,f);

	fclose(f);

	return 0;
}


int writergbim(char *s, struct basic_image *im)
{
	FILE *f;

  if ((f=fopen(s,"wb"))==NULL)
   return -1;

	fwrite(im->p,3*im->nc*im->nl,1,f);

	fclose(f);

	return 0;
}

int writeppmim(char *s, struct basic_image *im)
{
	FILE *f;

  if ((f=fopen(s,"wb"))==NULL)
   return -1;

	fprintf(f,"P6\n");
	fprintf(f,"%d %d 255\n",im->nc,im->nl);
	fwrite(im->p,3*im->nc*im->nl,1,f);

	fclose(f);

	return 0;
	
}

void	rdpixel(struct basic_image *im,int l,int c,u8 *r,u8 *v,u8 *b)
{
	u8 *p;

	p = im->p + 3*(im->nc*l+c);

	*r=*p++;
	*v=*p++;
	*b=*p;
}

void  wrpixel(struct basic_image *im,int l,int c,u8 r,u8 v,u8 b)
{
	u8 *p;

	p = im->p + 3*(im->nc*l+c);

	*p++=r;
	*p++=v;
	*p=b;

}



int main(int argc, char **argv)
{

  char seven[256];
  char sodd[256];
	char sout[256];
	char head[256];
	char heado[256];
	char heade[256];
	char hhead[256];
	char syscmd[256];

   struct basic_image im[3];

  int i,l,c,nl,nc;
	u8 r,v,b,r1,v1,b1,r2,v2,b2;

	int n;
	int imstart, imend;

	if (argc<3)
	{
		printf("Syntax is :\n gif2gif im#start im#end width height\n");
		exit(0);
	}


	imstart = atoi(argv[1]);;
	imend = atoi(argv[2]);;

  if (argc>3)
	{
	 nc = atoi(argv[3]);
	 nl = atoi(argv[4]);
	}
	else
	{
	 nc = 720;
	 nl = 270;
	}


  im[0].nl = nl;
  im[1].nl = nl;
  im[2].nl = 2*nl;
  im[0].nc = 2*nc;
  im[1].nc = 2*nc;
  im[2].nc = nc;
	
	n=2;

	newim(&im[0]);
	newim(&im[1]);
  newim(&im[2]);

  for (n=imstart;n<=imend;n+=2)
  { 
	 sprintf(heado, "im%05d",n);
	 sprintf(heade, "im%05d",n+1);
	 sprintf(hhead,"im%05d",n/2);

   sprintf(sodd ,"%s.raw",heado);
   sprintf(seven,"%s.raw",heade);
   sprintf(sout, "_tmp.ppm",head);


	 sprintf(syscmd,"gif2rgb -1 -o %s %s.gif",sodd,heado);
	 system(syscmd);

	 sprintf(syscmd,"gif2rgb -1 -o %s %s.gif",seven,heade);
	 system(syscmd);


	 printf("\n%05d == %s+%s==>%s\n",n,sodd, seven, sout);

	 readim(sodd, &im[0]);
	 readim(seven,&im[1]);


/* Filtrage et entrelacement */

  for (l=0;l<nl;l++)
    for (i=0;i<2;i++)
		 for (c=0;c<nc;c++)
		 {
			 rdpixel(&im[i],l,2*c  ,&r1,&v1,&b1);
			 rdpixel(&im[i],l,2*c+1,&r2,&v2,&b2);
			 r=(u8) (((int)r1+(int)r2)/2);
			 v=(u8) (((int)v1+(int)v2)/2);
			 b=(u8) (((int)b1+(int)b2)/2);
			 wrpixel(&im[2],2*l+i,c,r,v,b);
		 }

/*  writeim(sout,&im[2]); */
  writeppmim(sout,&im[2]);

/*  sprintf(syscmd,"rgb2gif -c 8 -1 -s %d %d %s > _%s.gif",im[2].nc, im[2].nl,sout,hhead); */
	printf("raw2tiff -c packbits %s %s.tif",sout,hhead);
  sprintf(syscmd,"raw2tiff -c packbits %s %s.tif",sout,hhead);
  system(syscmd);

  sprintf(syscmd,"del %s",seven);
  system(syscmd);
  sprintf(syscmd,"del %s",sodd);
  system(syscmd);
	

	}
 		 
  sprintf(syscmd,"del %s",sout);
  system(syscmd);

	freeim(&im[0]);
	freeim(&im[1]);
  freeim(&im[2]);

 return 0;
}