#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef unsigned long int ulint;

// Real Display Framerate 25 for PAL, 29.97 for NTSC
#define REAL_FRAME_RATE 25
// Framerate on the Adobe Premiere TimeLine 25 for PAL, 
// In premiere, NTSC DO SELECT "NOT Compensated TimeCode 30fps" on the timeline
// and define TIMELINE_FRAME_RATE 30
#define TIMELINE_FRAME_RATE 25
// Rythm in beats per seconds
#define beat (380.3/190.0)
// Frame from which you want to count beats. Should be positive.
#define SHIFT_IN_FRAMES (10*REAL_FRAME_RATE+16)
// Go until this Pulse number
#define LAST_PULSE 430

void frame_to_timecode(ulint frame, ulint *h, ulint *m, ulint *s, ulint *i)
{
 *i = (ulint) fmod(frame,TIMELINE_FRAME_RATE);
 frame = frame - *i;
 *s = (ulint) fmod((frame/TIMELINE_FRAME_RATE),60);
 frame = frame - *s*TIMELINE_FRAME_RATE;
 *m = (ulint) fmod((frame/TIMELINE_FRAME_RATE/60),60);
 frame = frame - *m*TIMELINE_FRAME_RATE*60;
 *h = (ulint) fmod((frame/TIMELINE_FRAME_RATE/3600),24);
}


void main(void)
{
 ulint h,m,s,i;
 ulint frame;
 ulint pulse;
 FILE *f;

 f=fopen("tbase.txt","wt");

 for (pulse=0;pulse<LAST_PULSE;pulse+=1)
 {
  frame = (ulint) ((REAL_FRAME_RATE / beat * pulse) + SHIFT_IN_FRAMES);
  frame_to_timecode(frame,&h,&m,&s,&i);
  printf("%04lu %02lu:%02lu':%02lu:%02lu\n",frame,h,m,s,i);
  fprintf(f,"%04lu %04lu %03lu %02lu:%02lu'%02lu\"%02lu\n",(ulint) (REAL_FRAME_RATE / beat * pulse),frame,pulse,h,m,s,i);
 }

 fcloseall();
}